const $ = s => document.querySelector(s); const $$ = s => Array.from(document.querySelectorAll(s));
function csrf() { const m = document.querySelector('meta[name="csrf-token"]'); return m ? m.content : '' }
function fmtEUR(c) { try { return new Intl.NumberFormat('es-ES', { style: 'currency', currency: 'EUR' }).format((c || 0) / 100) } catch (e) { return `${(c || 0) / 100} \u20ac` } }
function parseEURtoCents(v) { let s = String(v ?? '').trim(); if (!s) return 0; s = s.replace(/\u20ac/g, '').trim(); if (/[.,]/.test(s)) { const euros = parseFloat(s.replace(',', '.')) || 0; return Math.round(euros * 100) } const n = Number(s); if (!Number.isFinite(n)) return 0; return Math.max(0, Math.round(n * 100)) }
function nowTick() { const el = $('#now'); if (!el) return; const d = new Date(); el.textContent = d.toLocaleString('es-ES', { dateStyle: 'full', timeStyle: 'short' }) }
setInterval(nowTick, 1000); nowTick();

let CAL = null; let RES_PAGE = 1; let RES_TOTAL_PAGES = 1; let RES_Q = ''; let EDITING_ID = null;
let USERS_CACHE_BY_ID = {}; let DOCENTES = [];
let __PER_STUDENT_OVERRIDES = {};
const RES_PAGE_SIZE = 5;

async function api(url, opt = {}) { const res = await fetch(url, Object.assign({ credentials: 'same-origin', headers: { 'X-CSRF-Token': csrf(), 'Content-Type': 'application/json' } }, opt)); if (!res.ok) throw await res.json().catch(() => ({ detail: 'Error' })); return res.json() }
async function apiGet(url) { return api(url, { method: 'GET' }) }
async function apiPost(url, body) { return api(url, { method: 'POST', body: JSON.stringify(body) }) }
async function apiPatch(url, body) { return api(url, { method: 'PATCH', body: JSON.stringify(body) }) }
async function apiDelete(url) { return api(url, { method: 'DELETE' }) }

function notify(msg, type = 'info') { const n = document.createElement('div'); n.textContent = typeof msg === 'string' ? msg : (msg && msg.detail) || 'Error'; n.className = `toast ${type}`; Object.assign(n.style, { position: 'fixed', right: '16px', bottom: '16px', padding: '10px 12px', background: type === 'error' ? '#b3261e' : '#2e7d32', color: '#fff', borderRadius: '8px', zIndex: 9999, boxShadow: '0 6px 24px rgba(0,0,0,.2)' }); document.body.appendChild(n); setTimeout(() => n.remove(), 3000) }

async function loadDocentes() { const all = await apiGet('/api/users?role=docente'); DOCENTES = Array.isArray(all) ? all : []; const sel = $('#res-docente'); if (sel) { sel.innerHTML = '<option value="">\u2014 Sin docente \u2014</option>' + DOCENTES.map(d => `<option value="${d.id}">${d.name || d.email || ('Docente ' + d.id)}</option>`).join('') } }
async function loadAlumnosIntoSelect() { const sel = $('#res-user'); if (!sel) return; sel.innerHTML = ''; const list = await apiGet('/api/users?role=alumno'); const term = ($('#alumno-search') || { value: '' }).value?.toLowerCase?.() || ''; list.filter(u => !term || `${u.name || ''} ${u.email || ''}`.toLowerCase().includes(term)).forEach(u => { const opt = document.createElement('option'); opt.value = String(u.id); opt.textContent = `${u.name || u.email || ('Alumno ' + u.id)} \u2014 ${u.email || ''}`; sel.appendChild(opt); USERS_CACHE_BY_ID[u.id] = u }) }
function getSelectedStudentIds() { const sel = $('#res-user'); return Array.from(sel?.options || []).filter(o => o.selected).map(o => Number(o.value)).filter(Boolean) }
function getBasePriceCents() { const el = $('#res-price'); const cents = parseEURtoCents(el ? el.value : '35'); return cents > 0 ? cents : 3500 }
function getCentsForUser(uid) { const o = __PER_STUDENT_OVERRIDES[uid]; return Number.isFinite(o) && o > 0 ? o : getBasePriceCents() }

function openModalCreate(dateStr = null, timeStr = null) {
  EDITING_ID = null;
  __PER_STUDENT_OVERRIDES = {};
  $('#reservaModalTitle').innerHTML = '<i class="fas fa-pen-to-square"></i> Nueva Reserva';
  $('#res-delete').style.display = 'none';
  $('#res-date').value = dateStr || '';

  if (timeStr) {
    $('#res-time').value = timeStr;
  } else {
    const defChip = document.querySelector('.chips [data-time].primary') || document.querySelector('.chips [data-time]');
    $('#res-time').value = defChip ? defChip.getAttribute('data-time') : '';
  }

  $('#res-duration').value = '60';
  $('#res-status').value = 'confirmada';
  $('#res-docente').value = '';
  $('#res-name').value = '';
  $('#res-email').value = '';
  $('#res-phone').value = '';
  $('#res-notes').value = '';
  const paidEl = $('#res-paid'); if (paidEl) paidEl.checked = false;
  $('#reservaModalOverlay').classList.add('active')
}

function closeModal() { EDITING_ID = null; $('#reservaModalOverlay').classList.remove('active') }

function bindModalBasics() {
  $('#btnNuevaReserva')?.addEventListener('click', () => openModalCreate());
  $('#reservaCloseBtn')?.addEventListener('click', closeModal);
  $('#res-cancel')?.addEventListener('click', closeModal);
  $('#alumno-search')?.addEventListener('input', () => loadAlumnosIntoSelect());
  const overlay = $('#reservaModalOverlay');
  const modal = $('#reservaModal');
  overlay?.addEventListener('mousedown', e => { if (e.target === overlay) closeModal() });
  modal?.addEventListener('mousedown', e => e.stopPropagation());
  document.addEventListener('keydown', e => { if (e.key === 'Escape' && overlay?.classList.contains('active')) closeModal() });
  $$('.chips [data-time]').forEach(ch => ch.addEventListener('click', () => { $('#res-time').value = ch.getAttribute('data-time') || ''; $$('.chips [data-time]').forEach(c => c.classList.remove('primary')); ch.classList.add('primary') }));
  $$('.chips [data-duration]').forEach(ch => ch.addEventListener('click', () => { $('#res-duration').value = ch.getAttribute('data-duration') || '60'; $$('.chips [data-duration]').forEach(c => c.classList.remove('primary')); ch.classList.add('primary') }));
  $$('.chips [data-price]').forEach(ch => ch.addEventListener('click', () => { $('#res-price').value = ch.getAttribute('data-price') || '35'; $$('.chips [data-price]').forEach(c => c.classList.remove('primary')); ch.classList.add('primary') }));
}

async function ensureUser(id) { if (USERS_CACHE_BY_ID[id]) return USERS_CACHE_BY_ID[id]; const u = await apiGet(`/api/users/${id}`); USERS_CACHE_BY_ID[id] = u; return u }

async function submitReserva(ev) {
  ev.preventDefault();
  const form = $('#reservaForm');
  const btn = $('#reservaForm button[type="submit"]');
  if (btn) { btn.disabled = true; btn.dataset._txt = btn.innerHTML; btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Guardando\u2026' }
  const payload = {
    date: ($('#res-date') || {}).value?.trim(),
    time: ($('#res-time') || {}).value?.trim()?.slice(0, 5),
    duration_minutes: parseInt(($('#res-duration') || {}).value || '60', 10) || 60,
    status: ($('#res-status') || {}).value || 'confirmada',
    teacher_id: ($('#res-docente') || {}).value ? Number($('#res-docente').value) : null,
    name: ($('#res-name') || {}).value?.trim() || null,
    email: ($('#res-email') || {}).value?.trim() || null,
    phone: ($('#res-phone') || {}).value?.trim() || null,
    notes: ($('#res-notes') || {}).value?.trim() || null,
    user_ids: getSelectedStudentIds(),
    price_cents: getBasePriceCents(),
    per_student_cents: {}
  };
  const paidEl = $('#res-paid'); payload.paid = paidEl ? !!paidEl.checked : false;
  payload.user_ids.forEach(id => payload.per_student_cents[id] = getCentsForUser(id));

  try {
    if (!payload.date || !payload.time) { notify('Indica fecha y hora', 'error'); return }
    if (EDITING_ID) { await apiPatch(`/api/reservations/${EDITING_ID}`, payload) } else { await apiPost('/api/reservations', payload) }
    notify('Reserva guardada', 'ok');
    closeModal(); await refreshCalendar(); await loadReservationsPage(RES_PAGE);
  } catch (err) {
    const msg = (err && err.detail) || 'No se pudo guardar la reserva';
    notify(msg, 'error');
    console.error('Reserva error:', err);
  } finally {
    if (btn) { btn.disabled = false; btn.innerHTML = btn.dataset._txt || 'Guardar'; delete btn.dataset._txt }
  }
}

function bindFormSubmit() {
  const form = $('#reservaForm');
  if (form) { form.setAttribute('novalidate', ''); form.addEventListener('submit', submitReserva) }
}
function bindDelete() { const btn = $('#res-delete'); if (!btn) return; btn.addEventListener('click', async () => { if (!EDITING_ID) return; try { await apiDelete(`/api/reservations/${EDITING_ID}`); notify('Reserva eliminada', 'ok'); closeModal(); await refreshCalendar(); await loadReservationsPage(RES_PAGE) } catch (e) { notify((e && e.detail) || 'No se pudo eliminar', 'error') } }) }

function resRow(r) {
  const tCreated = new Date(r.created_at || r.created || r.createdAt || Date.now());
  const alumno = r.user_name || r.name || ''; const mail = r.user_email || r.email || '';
  const docente = r.teacher_name || r.docente || '';
  const id = r.id;
  return `<tr data-id="${id}">
    <td>#${id} \u2014 ${alumno || '(sin alumno)'}</td>
    <td>${r.date || ''}</td>
    <td>${(r.time || '').slice(0, 5)}</td>
    <td>${alumno || ''}</td>
    <td>${mail || ''}</td>
    <td>${docente || '\u2014'}</td>
    <td>${tCreated.toLocaleString('es-ES')}</td>
    <td>
      <button class="btn btn-secondary" data-act="edit">Editar</button>
      <button class="btn btn-danger" data-act="del">Borrar</button>
    </td>
  </tr>`
}

function normalizeListResponse(data) { if (Array.isArray(data)) return data; if (Array.isArray(data.items)) return data.items; if (Array.isArray(data.results)) return data.results; if (Array.isArray(data.data)) return data.data; return [] }

function parseLocalDateTime(r) { const date = r.date; const time = (r.time || '00:00').slice(0, 5); const [Y, M, D] = (date || '1970-01-01').split('-').map(Number); const [h, m] = (time || '00:00').split(':').map(Number); return new Date(Y, (M - 1), D, h || 0, m || 0, 0, 0).getTime() }

async function loadReservationsPage(page = 1) {
  const data = await apiGet(`/api/reservations`);
  let rows = normalizeListResponse(data);
  if (RES_Q) { const q = RES_Q.toLowerCase(); rows = rows.filter(r => `${r.user_name || r.name || ''} ${r.user_email || r.email || ''}`.toLowerCase().includes(q)) }
  rows = rows.slice().sort((a, b) => parseLocalDateTime(b) - parseLocalDateTime(a));
  const total = Math.max(1, Math.ceil(rows.length / RES_PAGE_SIZE));
  const p = Math.min(Math.max(1, page), total);
  RES_PAGE = p; RES_TOTAL_PAGES = total;
  const start = (p - 1) * RES_PAGE_SIZE; const pageRows = rows.slice(start, start + RES_PAGE_SIZE);
  const tbody = $('#reservationsTable tbody'); tbody.innerHTML = pageRows.length ? pageRows.map(resRow).join('') : '<tr><td colspan="8" class="muted">Sin resultados</td></tr>';
  $('#resPageInfo').textContent = `Página ${RES_PAGE} de ${RES_TOTAL_PAGES}`;
  console.log('Pagination updated:', { RES_PAGE, RES_TOTAL_PAGES, totalRows: rows.length });
  $('#resPrev').disabled = RES_PAGE <= 1; $('#resNext').disabled = RES_PAGE >= RES_TOTAL_PAGES;
}

function bindListControls() {
  $('#refreshReservations')?.addEventListener('click', () => loadReservationsPage(RES_PAGE));
  $('#searchReservations')?.addEventListener('input', e => { RES_Q = e.target.value || ''; loadReservationsPage(1) });
  const prevBtn = $('#resPrev');
  const nextBtn = $('#resNext');
  console.log('Binding pagination controls:', { prevBtn, nextBtn });
  prevBtn?.addEventListener('click', () => { console.log('Prev clicked, current page:', RES_PAGE); loadReservationsPage(RES_PAGE - 1) });
  nextBtn?.addEventListener('click', () => { console.log('Next clicked, current page:', RES_PAGE); loadReservationsPage(RES_PAGE + 1) });
  $('#reservationsTable')?.addEventListener('click', async e => {
    const btn = e.target.closest('button[data-act]'); if (!btn) return;
    const tr = e.target.closest('tr[data-id]'); if (!tr) return; const id = Number(tr.getAttribute('data-id'));
    const act = btn.getAttribute('data-act');
    if (act === 'del') { EDITING_ID = id; try { await apiDelete(`/api/reservations/${id}`); notify('Reserva eliminada', 'ok'); await refreshCalendar(); await loadReservationsPage(RES_PAGE) } catch (err) { notify((err && err.detail) || 'No se pudo eliminar', 'error') } }
    if (act === 'edit') { const r = await apiGet(`/api/reservations/${id}`); await openModalEdit(r) }
  });
}

async function openModalEdit(r) {
  EDITING_ID = r.id;
  __PER_STUDENT_OVERRIDES = {};
  $('#reservaModalTitle').innerHTML = `<i class="fas fa-pen-to-square"></i> Editar Reserva #${r.id}`;
  $('#res-delete').style.display = '';
  $('#res-date').value = r.date || '';
  $('#res-time').value = (r.time || '').slice(0, 5);
  $('#res-duration').value = r.duration_minutes || r.duration || r.duration_min || 60;
  $('#res-status').value = r.status || 'confirmada';
  $('#res-docente').value = r.teacher_id || r.docente_id || '';
  $('#res-name').value = r.name || '';
  $('#res-email').value = r.email || '';
  $('#res-phone').value = r.phone || '';
  $('#res-notes').value = r.notes || '';
  await loadAlumnosIntoSelect();
  const sel = $('#res-user');
  let ids = [];
  if (Array.isArray(r.user_ids) && r.user_ids.length) { ids = r.user_ids.map(Number) }
  else if (Array.isArray(r.student_ids) && r.student_ids.length) { ids = r.student_ids.map(Number) }
  else if (Array.isArray(r.alumnos) && r.alumnos.length) { ids = r.alumnos.map(Number) }
  else if (Array.isArray(r.students) && r.students.length) { ids = r.students.map(s => Number(s.id)) }
  Array.from(sel.options).forEach(o => o.selected = ids.includes(Number(o.value)));
  if (r.per_student_cents) Object.keys(r.per_student_cents).forEach(k => { __PER_STUDENT_OVERRIDES[Number(k)] = Number(r.per_student_cents[k]) || 0 });
  const paidEl = $('#res-paid'); if (paidEl) paidEl.checked = !!(r.paid || r.has_paid);
  $('#reservaModalOverlay').classList.add('active');
}

function fcEventsFromReservations(list) {
  return list.map(r => {
    const date = r.date;
    const time = (r.time || '00:00').slice(0, 5);
    const dur = r.duration_minutes || r.duration || r.duration_min || 60;
    const [Y, M, D] = date.split('-').map(Number);
    const [h, m] = (time || '00:00').split(':').map(Number);
    const startDate = new Date(Y, (M - 1), D, h || 0, m || 0, 0, 0);
    const endDate = new Date(startDate.getTime() + dur * 60000);

    const isPaid = !!r.paid;
    const colorPaid = '#4caf50';
    const colorUnpaid = '#ff9800';
    const bg = isPaid ? colorPaid : colorUnpaid;

    return {
      id: String(r.id),
      title: (r.user_name || r.name || 'Reserva'),
      start: startDate,
      end: endDate,
      backgroundColor: bg,
      borderColor: bg,
      extendedProps: r
    };
  })
}


async function refreshCalendar() {
  const data = await apiGet('/api/reservations'); const items = normalizeListResponse(data);
  const events = fcEventsFromReservations(items); CAL?.removeAllEvents(); events.forEach(ev => CAL.addEvent(ev))
}

function initCalendar() {
  const el = document.getElementById('calendar'); if (!el) return;
  CAL = new FullCalendar.Calendar(el, {
    initialView: 'dayGridMonth', locale: 'es', headerToolbar: { left: 'prev,next today', center: 'title', right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek' },
    dateClick: info => { openModalCreate(info.dateStr, null) },
    eventClick: async info => { const id = Number(info.event.id); const r = await apiGet(`/api/reservations/${id}`); openModalEdit(r) }
  });
  CAL.render();
}

async function boot() {
  bindModalBasics(); bindFormSubmit(); bindDelete(); bindListControls();
  await loadDocentes(); await loadAlumnosIntoSelect();
  initCalendar();
  await refreshCalendar();
  await loadReservationsPage(1);
}
document.addEventListener('DOMContentLoaded', boot);
